function results= FlipMA(vMA)

% PURPOSE: A function to ensure that the roots of the MA part are stationary ,
%          if not, the function inverts roots  
% -------------------------------------------------------
% Usage:  results= FlipMA(vMA)
% Where:    vMA = a coefficient vector of MA
% -------------------------------------------------------
% RETURNS:
%           results = a coefficient vector of MA which roots are stationary.  
% -------------------------------------------------------
% ACKNOWLEDGEMENT: The original ARFIMA code was written by Jurgen A Doornik
% -----------------------------------------------------

% The matlab port written and changed by
% Ying Ma
% yingma@email.com

    
    if  isempty(vMA) 
        error('The nq  can must be greater than zero.');
    end
    
    vroots = roots([1 vMA']); 
    for i = 1:length(vroots)
        if abs(vroots(i))>1
            vroots(i)= 1/vroots(i); % reconstruct  MA parameters by inverting roots outside unit circle  
        end
    end 
    vMA = poly(vroots);
    results = vMA(2:end)';

