function bo = IsStationary(mtheta, d)
% PURPOSE: check if the roots of the AR part and d are stationary ones or not 
% -------------------------------------------------------
% Usage:    bo = IsStationary (mtheta, d)
% Where:    mtheta = a theta coefficient matrix
%           d      = a degree of fractional integration 
% -------------------------------------------------------
% RETURNS:
%           bo = 1 if the AR part is stationary, 0 if not
% -------------------------------------------------------
% NOTES:    
% -------------------------------------------------------
% ACKNOWLEDGEMENT: The original ARFIMA code was written by Jurgen A Doornik
% -----------------------------------------------------

% The matlab port written and changed by
% Ying Ma
% yingma@email.com

    if nargin < 2
        d =0;
    end
    
    if d <= -1.0 | d > 0.49999999
        bo  = 0;
        return;
    end
    
    if ~isempty(mtheta) % check if AR roots are inside unit circle
        polyroots = roots([-1 mtheta']);
        if max(abs(polyroots)) >= 0.99999
            bo = 0;
            return;
        end
    end
    
    bo = 1;
