function result = SolveAR (series, np, nq)
% PURPOSE: Solve the Yule-Walker equations for AR values
% -------------------------------------------------------
% Usage:  result = SolveAR (series, np, nq)
% Where:    series = a series matrix
%           np = the order of p, nq = the order of q
% -------------------------------------------------------
% RETURNS:
%           result = the parameters of the AR part.
% -------------------------------------------------------
% NOTES:    We use OLS to solve this system
% -------------------------------------------------------
% ACKNOWLEDGEMENT: The original ARFIMA code was written by Jurgen A Doornik
% -----------------------------------------------------

% The matlab port written and changed by
% Ying Ma
% yingma@email.com
    
    if nargin < 2 | np <=0
        error('The np  can must be greater than zero.');
    end
    
    if nargin > 2 & nq <0
        error('The nq  can must be not less than zero.');
    end
       
    npq  =   np + nq;
    macf = acf(series,  npq);
    
    mxt  = flipud(macf(2:np+1,:));
    
    mxt  = [mxt; macf];
    mx1   = lagmatrix(mxt,[1:np]);
    mx   = mx1(npq+2:npq+np+1,:);
    
    my  = macf(nq+2:npq+1,:);

    result = olsv(my, mx);
