function result = TrimMatrix(mX, nT)
% PURPOSE: Truncating the matrix to nT rows
% -------------------------------------------------------
% Usage:  result = TrimMatrix(mX, nT)
% Where: 
%           mX = the matrix whose rows are greater than nT
% -------------------------------------------------------
% RETURNS:
%           result = the matrix which was trimmed
% -------------------------------------------------------

% Written and changed by
% Ying Ma
% yingma@email.com


    if isempty(mX)
        error('Error:empty matrix');
    end
    
    [nR, nC] = size(mX);
    
    if nT <= nR
        result = mX(1:nT,:);
    else
        result = [mX; zeros(nT-nR, nC)];
    end