% PURPOSE: A demonstrated example using ARFIMA                                                    
%---------------------------------------------------

% Written and changed by
% Ying Ma
% yingma@email.com

Vol = load('-ASCII','ff.mat');

parameters = Doinit(1, Vol(1:1099), 2, 2,[], ones(1099,1));

%-----------------------------------------------------------------------------------------
% Estimate the parameters for the ARFIMA model
%-----------------------------------------------------------------------------------------

[vParameters fLogvar vMean] = DoEstimation('MPL', Vol(1:1099), parameters, 2, 2,[]);


%-----------------------------------------------------------------------------------------
% Do five-day-ahead out of sample ARFIMA Forecasts from the 900th tick of time series to 
%   the 920th tick
%-----------------------------------------------------------------------------------------

for i =1:5:20
        [mforcasts, mrmses, mes] = Doforecast(0, 1099+i, 5, Vol,  fLogvar, vParameters, 2, 2, vMean);
        y1ev(i:i+4,:)=mforcasts(:);
end

%-----------------------------------------------------------------------------------------
% Display and compare the resulting plot of the observations and forecasts
%-----------------------------------------------------------------------------------------

y1= Vol(1100:1119);

x = 1:20;
figure;
plot(x,y1,x,y1ev);
title('Time Series and five-day-ahead Out-of-Sample ARFIMA Forecasts')
ylabel('Forecasts and Realizations');
xlabel('Time');    
legend('Time Series','ARFIMA Forecasts');
pause;
   



