function hyp= hypergm(a,b,z,niter,feps)
% PURPOSE: The hypergeometric function
% -----------------------------------------------------
% USAGE:     hyp= hypergm(a,b,z,niter,feps)
% where:     a, b: the variables of function:a and c, b =1
%            z: the roots of the AR polynomial
%            niter   : the number of iterations
%            feps : the required precision
% -----------------------------------------------------
% RETURNS:   result= The likelihoods of Time series
% -----------------------------------------------------             
% NOTE:      The function is used in the maximum likelihood procedure.
% -----------------------------------------------------
% ACKNOWLEDGEMENT: The original ARFIMA code was written by Jurgen A Doornik
% -----------------------------------------------------

% The matlab port written and changed by
% Ying Ma
% yingma@email.com

error(nargchk(4, 5, nargin));
if (nargin <= 4) 
   feps = eps;
end;

% Initialization
hyp= 1;
inc= 1;
for ii=0:niter,
    inc= inc*z*(a+ii)/(b+ii);
    hyp= hyp+inc;
    if (abs(inc) < feps) 
       return; 
    end;
end
