function [beta, resid]=olsv(y, x)
% PURPOSE: least-squares regression 
% -----------------------------------------------------
% USAGE:     results = ols(y,x)
% where: y = dependent variable vector   
%        x = independent variables matrix 
% -----------------------------------------------------
% RETURNS:   beta  = bhat 
%            resid = residuals
% -----------------------------------------------------             
% NOTE:      
% -----------------------------------------------------

% The matlab port written by:
% Ying Ma
% yingma@email.com

    [q r] = qr(x,0);
    xpxi = (r'*r)\eye(size(x,2));
    beta = xpxi*(x'*y);
    if nargout >1 
        yhat = x*beta;
        resid = y - yhat;
    end