function [result, logdet] = pacf(acf, my)

% PURPOSE: Return a matrix with the residuals from the filter based on the ACF applied to the columns 
% -----------------------------------------------------
% USAGE:     [result, logdet] = ols(y,x)
% where:     acf = a matrix of autocovariances or autocorrelations 
%            my = a matrix to apply filter to 
% -----------------------------------------------------
% RETURNS:   results  = the matrix after applying filter acf 
%            logdet = the standard devations of the residuals
% -----------------------------------------------------             
% NOTE:      


% Written and changed by
% Ying Ma
% yingma@email.com


    [n m] = size(acf);
    [e f] = size(my);
    
    mtoep =  toeplitz(acf);
    
    [t, p] = chol(mtoep);
    
    if p > 0
        j = p-1;
    else
        j = n;
    end

    t   =   t';
   
    result = my;
    
    for k = 1:j;
        result(k,:)   = result(k,:) / t( k, k);
        if k < j 
            result((k+1),:) = result((k+1),:) - t((k+1), 1:k) * result(1:k,:);
        end        
    end
    
    if j < e
        result(j+1:e,:) = zeros(e-j, f);
    end
    
    if nargout > 1 
        logdet = log(det(mtoep));
        logdet = real(logdet);
    end