function results = powerdiff(d,mSeries,nTrunc);

% PURPOSE: This operation involves computing a long (in theory infinite, in practice long, but truncated)
% -----------------------------------------------------
% USAGE:     [result, logdet] = ols(y,x)
% where:     d = a degree of fractional integration 
%            mSeries = a matrix of time series 
%	     nTrunc  = the number of truncation
% -----------------------------------------------------
% RETURNS:   results  = the matrix after applying filter 
% -----------------------------------------------------             
% NOTE:      
% -----------------------------------------------------

% Written and changed by
% Ying Ma
% yingma@email.com


if (nargin < 2)
  error('Error:The fractional difference requires at least two parameter.');
end

if isempty(mSeries)
    error('Error:The fractional difference requires a time series input.');
end

[nT nY] =   size(mSeries);

if nT == 1 
    mSeries = mSeries';
    [nT nY] =   size(mSeries); 
end

if nargin < 3 
   nTrunc = nT-1;
end

% fractional models 
c= zeros(nTrunc,1);
c(1)=d;

for m=2:nTrunc;
  c(m) = c(m-1) * (m-1-d) / m;
end;

c = c';

results = zeros(nT,nY);

results(1,:)= mSeries(1,:);

for i=2:nT;
    results(i,:)=mSeries(i,:)-c(:,1:i-1)*mSeries(i-1:-1:1,:);    
end
