function cout = c_sarf(rho1,rho2,rho3,sige,Q,traces,n,nvars);
% PURPOSE: evaluate the conditional distribution of rho given sige
%  spatial autoregressive model using sparse matrix algorithms
% ---------------------------------------------------
%  USAGE:cout = c_sarf(rho1,rho2,rho3,Q,traces,a1,a2)
%  where:  rho1 = spatial autoregressive parameter for the draw
%          rho2 = conditioning on the other parameter
%          rho3 = conditioning on the other parameter
%          y    = dependent variable vector
%          W    = spatial weight matrix
%        detval = an (ngrid,2) matrix of values for det(I-rho*W) 
%                 over a grid of rho values 
%                 detval(:,1) = determinant values
%                 detval(:,2) = associated rho values
%          sige = sige value
%          a1    = (optional) prior parameter for rho
%          a2    = (optional) prior parameter for rho
%        flag    = 1 or 2 for rho1 or rho2 conditional
% ---------------------------------------------------
%  RETURNS: a conditional used in Metropolis-Hastings sampling
%  NOTE: called only by sarf3_g
%  --------------------------------------------------
%  SEE ALSO: sar_g, c_far, c_sac, c_sem
% ---------------------------------------------------

tau = [1
       -rho1
       -rho2
       -rho3];
   
pvec = [rho1
        rho2
        rho3];
    
logdet = fodet1(pvec,traces,n);

epe = tau'*Q*tau;

cout =   logdet - epe/(2*sige);

