function [traces]=ftrace1(w,miter,riter)
%
%function [traces]=ftrace1(w,miter,riter)
%
%This function estimates the first miter traces of w, an n by n spatial weight matrix with maximum eigenvalue of 1, 
%and zeros on the diagonal. 
%
%Inputs:
%
%w, an n by n spatial weight matrix with maximum eigenvalue of 1, %and zeros on the diagonal. 
%A row-stochastic, doubly stochastic scaling will give a maximum eigenvalue of 1. 
%Matrices similar to %stochastic matrices will satisfy this as well.
%Finally, one can find the maximum eigenvalue, and scale a candidate weight matrix by this to yield a weight
% maxtrix with maximum eigenvalue of 1. Note, one can find the maximum eigenvalue of a sparse d using the command 
%eigs in a reasonable time for moderately large matrices.
%
%miter, the maximum order trace desired
%
%riter, the maximum number of iterations used to estimate the traces
%
%Output:
%
%traces, the first miter traces of w
%
%
%NOTES:
%
%If you use this function, please cite:
% 
% Barry, Ronald, and R. Kelley Pace, 
% "A Monte Carlo Estimator of the Log Determinant of Large Sparse Matrices," 
% Linear Algebra and its Applications, Volume 289, Number 1-3, 1999, p. 41-54.
% 
% Written by Kelley Pace, www.spatial-statistics.com, on 5/5/05 (based on fdet_mc2)


n=size(w,1);
tmat=zeros(miter,riter);

for jj=1:riter
u=2*round(rand(n,1))-1;
wu=u;
for ii=1:miter
    wu=w*wu;
    tmat(ii,jj)=mean(sum(u.*wu));
end
end

traces=mean(tmat')';

%substitutes exact traces for the first two traces
traces(1)=trace(w);
traces(2)=sum(sum(w'.*w));







