% A demonstration file
% this calls an unconstrained optimization routine: fminunc()
% from the MathWorks Inc. optimization toolbox which you need to purchase
% a license for from the MATLAB company.

clear all;

%model = 1;
% model with rho1, rho2, rho3 unrestrcted
model = 2;
% model with rho3 = -rho1*rho2;
% model = 3;
% model with rho3 = 0


nmetro = 299;  % #metro areas - 1 
n = nmetro+1;

N = n*n;
ia = vec(eye(n));
iotan = ones(n,1);
iotaN = ones(N,1);

load metro_census_1990.data;
% 1  metro code
% 2 latt
% 3 long
% 4 associate
% 5 college
% 6 gradprof
% 7 samehouse
% 8 foreignborn
% 9 houseage
% 10 sales_emp
% 11 constr_emp
% 12 health_emp
% 13 fire_emp
% 14 traveltime
% 15 house_retired
% 16 retire_income
% 17 med_rent
% 18 med_mortgage
% 19 pc_income
% 20 pa_income
% 21 unemp
% 22 female_nowork
% 23 population in 1990

data = metro_census_1990(end-nmetro:end,:);

pop90 = log(data(:,23));
income90 = (data(:,19));
mort90 = (data(:,18));
travelt = (data(:,14));
samehouse = log(data(:,7)./(ones(n,1)-data(:,7)));


latt = data(:,2);
long = data(:,3);

G = distance(latt,long);

gv = vec(G);
ind = find(gv > 0);
Glog = zeros(n*n,1);
Glog(ind,1) = log(gv(ind,1));

gmean = mean(Glog);

gdev = Glog - gmean;

Gdot = reshape(gdev,n,n);

dg = diag(Gdot);

clear G;

xmatrix = [pop90 income90 travelt samehouse];

vnamesd = strvcat('D_pop90','D_income90','D_traveltime90','D_samehouse');
vnameso = strvcat('O_pop90','O_income90','O_traveltime90','O_samehouse');
vnamesi = strvcat('I_pop90','I_income90','I_traveltime90','I_samehouse');

xmean = mean(xmatrix);

X = matsub(xmatrix,xmean);

[junk,k] = size(X);


load metroflows_2000.data;
flows = metroflows_2000(2:end,2:end);

Y = flows(end-nmetro:end,end-nmetro:end);

yvec = vec(Y);

ind = find(yvec > 0);
yvec(ind,1) = log(yvec(ind,1));

Y = reshape(yvec,n,n);

Ysaved = Y; % these are used by the Tobit routine to find zero-values

dy = diag(Y);

[ysort,ysind] = sort(yvec);


clear flows;


% first-order contiguity matrix
[j,W,j] = xy2cont(latt,long);

options.lflag = 0;


% ==========================================================
% ============ now use the moment code for comparison
% ==========================================================

Y = reshape(yvec,n,n);


vnames = strvcat('log flows','constant','ia',vnamesd,vnameso,vnamesi,'distance');

iota = ones(n,1);
trd = iota'*(Gdot.*Gdot)*iota;


zpz = [N          n             zeros(1,k)         zeros(1,k)            zeros(1,k)  zeros(1,1)
       n          n             zeros(1,k)         zeros(1,k)            zeros(1,k)  trace(Gdot)
       zeros(k,1)  zeros(k,1)   n*X'*X             zeros(k,k)            X'*X        X'*Gdot*iota
       zeros(k,1)  zeros(k,1)   zeros(k,k)         n*X'*X                X'*X        X'*Gdot'*iota
       zeros(k,1)  zeros(k,1)   X'*X               X'*X                  X'*X        X'*dg 
       zeros(1,1)  trace(Gdot)   iota'*Gdot'*X      iota'*Gdot*X         dg'*X       trd];

[nvars,kk] = size(zpz);


[nvars,junk] = size(zpz);

%  E1 ---------------------------------------------

iota = ones(n,1);

trdy = sum(sum(Gdot'.*Y));

   zpy = [iota'*Y*iota  
       trace(Y)
       X'*Y*iota   
       X'*Y'*iota 
       X'*dy 
       trdy];

   beta1 = (zpz\zpy);
   
    % these are needed to update sige and rho
    alpha = beta1(1,1);
    ai    = beta1(2,1);
    bd = beta1(3:3+k-1,1);
    bo = beta1(3+k:3+2*k-1,1);
    bi = beta1(3+2*k:3+3*k-1,1);
    gamma = beta1(end,1);

    xia = ia*ai;
    xdb = kron(iota,X)*bd;
    xob = kron(X,iota)*bo;
    xib =  matmul(vec(eye(n)),kron(iota,X))*bi;


    E = vec(Y) - ones(n*n,1)*alpha - xia - xdb - xob - xib - vec(Gdot)*gamma;

    E1 = reshape(E,n,n);

%  E2 ---------------------------------------------

WY = W*Y;
% ---------------------------------------------

   trdy = sum(sum(Gdot'.*WY));
   
   zpy = [iota'*WY*iota  
       trace(WY)
       X'*WY*iota   
       X'*WY'*iota 
       X'*diag(WY)
       trdy];

    beta2 = (zpz\zpy);


    % these are needed to update sige and rho
    alpha = beta2(1,1);
    ai    = beta2(2,1);
    bd = beta2(3:3+k-1,1);
    bo = beta2(3+k:3+2*k-1,1);
    bi = beta2(3+2*k:3+3*k-1,1);
    gamma = beta2(end,1);

    xia = ia*ai;
    xdb = kron(iota,X)*bd;
    xob = kron(X,iota)*bo;
    xib =  matmul(vec(eye(n)),kron(iota,X))*bi;

    E = vec(WY) - ones(n*n,1)*alpha - xia - xdb - xob - xib - vec(Gdot)*gamma;

    E2 = reshape(E,n,n);

% E3 -----------------------------------

WY = Y*W';
% ---------------------------------------------

   trdy = sum(sum(Gdot'.*WY));
   
   zpy = [iota'*WY*iota  
       trace(WY)
       X'*WY*iota   
       X'*WY'*iota 
       X'*diag(WY)
       trdy];

    beta3 = (zpz\zpy);


    % these are needed to update sige and rho
    alpha = beta3(1,1);
    ai    = beta3(2,1);
    bd = beta3(3:3+k-1,1);
    bo = beta3(3+k:3+2*k-1,1);
    bi = beta3(3+2*k:3+3*k-1,1);
    gamma = beta3(end,1);

    xia = ia*ai;
    xdb = kron(iota,X)*bd;
    xob = kron(X,iota)*bo;
    xib =  matmul(vec(eye(n)),kron(iota,X))*bi;

    E = vec(WY) - ones(n*n,1)*alpha - xia - xdb - xob - xib - vec(Gdot)*gamma;

    E3 = reshape(E,n,n);


% E4 -----------------------------------

WY = W*Y*W';
% ---------------------------------------------
   trdy = sum(sum(Gdot'.*WY));
   
   zpy = [iota'*WY*iota  
       trace(WY)
       X'*WY*iota   
       X'*WY'*iota 
       X'*diag(WY)
       trdy];

    beta4 = (zpz\zpy);


    % these are needed to update sige and rho
    alpha = beta4(1,1);
    ai    = beta4(2,1);
    bd = beta4(3:3+k-1,1);
    bo = beta4(3+k:3+2*k-1,1);
    bi = beta4(3+2*k:3+3*k-1,1);
    gamma = beta4(end,1);

    xia = ia*ai;
    xdb = kron(iota,X)*bd;
    xob = kron(X,iota)*bo;
    xib =  matmul(vec(eye(n)),kron(iota,X))*bi;

    E = vec(WY) - ones(n*n,1)*alpha - xia - xdb - xob - xib - vec(Gdot)*gamma;

    E4 = reshape(E,n,n);


Q = zeros(4,4);

Q(1,1) = sum(sum(E1.*E1));
Q(1,2) = sum(sum(E1.*E2));
Q(1,3) = sum(sum(E1.*E3));
Q(1,4) = sum(sum(E1.*E4));
Q(2,1) = Q(1,2);
Q(3,1) = Q(1,3);
Q(4,1) = Q(1,4);
Q(2,2) = sum(sum(E2.*E2));
Q(2,3) = sum(sum(E2.*E3));
Q(2,4) = sum(sum(E2.*E4));
Q(3,2) = Q(2,3);
Q(4,2) = Q(2,4);
Q(3,3) = sum(sum(E3.*E3));
Q(3,4) = sum(sum(E3.*E4));
Q(4,3) = Q(3,4);
Q(4,4) = sum(sum(E4.*E4));

miter = 10;
riter = 60;


traces = ftrace1(W,miter,riter);
pvec=rand(3,1);
pvec=0.7*pvec/sum(pvec);%sum to 0.8



% step 2) maximize concentrated likelihood function;
warning off;
    timetmp = clock;
     options = optimset('fminunc');
     options = optimset('TolFun',1e-5);
     options = optimset('TolX',1e-5);
     ldetflag = 0;

     optimset(options,'Display','off');
     [pvec,liktmp,exitflag,output,grad,hess] = fminunc('f_sarfm',pvec,options, ...
         Q,n,traces,W,miter,riter,model,ldetflag);
disp('exit flag should be 1');
exitflag
    time2 = etime(clock,timetmp); % optimization time
    results.rho1 = pvec(1,1); 
    results.rho2 = pvec(2,1);
    results.rho3 = pvec(3,1);
    output
    grad
    hess
    pvec
    
    
beta = beta1 - pvec(1,1)*beta2 - pvec(2,1)*beta3 - pvec(3,1)*beta4;

kk = length(beta);

E = E1 - pvec(1,1)*E2 - pvec(2,1)*E3 - pvec(3,1)*E4;
e = vec(E);

na = n*n-kk;
sige = (e'*e)/na;
    
    % compute numerical hessian
    parm = [beta
            pvec
            sige];
         
y = vec(Y);

ldetflag = 1;
[junk,k] = size(xmatrix);
kk = 3*k+3;
%Loglike = f2_sarf(parm,y,x,Wo,Wd,Ww,n,traces,ldetflag);    
Loglike = f2_sarfm(parm,Q,n,k,kk,traces,W,miter,riter,model,X,Gdot,Y);

disp('log-likelihood function value');
Loglike

% asymptotic t-stats using numerical hessian
timetmp = clock;
% just computes the diagonal
% just computes the diagonal
% tic;
% dhessn = hessian('f2_sarft',parm,y,x,Wo,Wd,Ww,n,traces,ldetflag);
% toc;
tic;
dhessn = hessian('f2_sarfm',parm,Q,n,k,kk,traces,W,miter,riter,model,X,Gdot,Y);
toc;


hessi = invpd(dhessn);

tvar = abs(diag(hessi));
[k,junk] = size(tvar);

tmp = [beta
       pvec];
tstat = tmp./sqrt(tvar(1:k-1,1));
bstd = sqrt(tvar(1:k-3,1));
pstd = sqrt(tvar(k-2:k,1));
time3 = etime(clock,timetmp);
% end of t-stat calculations
disp('time for numerical hessian');
time3

    
mbeta_rho = [beta
            pvec];

tprob = tdis_prb(tstat,n*n);

in.rnames = strvcat(vnames,'rho1','rho2','rho3');
in.cnames = strvcat('beta hat','t-statistics','t-prob');

mprint([mbeta_rho tstat tprob],in);

disp('sige hat');
sige

% plot actual versus predicted
[ysort,yind] = sort(yvec);

% construct yhat
Wy1 = vec(W*Y);
Wy2 = vec(Y*W');
Wy3 = vec(W*Y*W');

rho1 = results.rho1;
rho2 = results.rho2;
rho3 = results.rho3;

[junk,k] = size(xmatrix);

alpha = beta(1,1);
ai    = beta(2,1);
bd = beta(3:3+k-1,1);
bo = beta(3+k:3+2*k-1,1);
bi = beta(3+2*k:3+3*k-1,1);
gamma = beta(end,1);

iota = ones(n,1);
ia = vec(eye(n));

xia = ia*ai;
xdb = kron(iota,X)*bd;
xob = kron(X,iota)*bo;
xib =  matmul(vec(eye(n)),kron(iota,X))*bi;


yhat = rho1*Wy1 + rho2*Wy2 + rho3*Wy3 + ones(n*n,1)*alpha + xia + xdb + xob + xib + vec(Gdot)*gamma;

yhats = yhat(yind,1);

tt=1:n*n;

plot(tt,ysort,'or',tt,yhats,'.g');

