% do MCMC vi-model using moment matrix approach

clear all;

%model = 1;
% model with rho1, rho2, rho3 unrestrcted
model = 2;
% model with rho3 = -rho1*rho2;
% model = 3;
% model with rho3 = 0


nmetro = 299;  % #metro areas - 1 
n = nmetro+1;

N = n*n;
ia = vec(eye(n));
iotan = ones(n,1);
iotaN = ones(N,1);

load metro_census_1990.data;
% 1  metro code
% 2 latt
% 3 long
% 4 associate
% 5 college
% 6 gradprof
% 7 samehouse
% 8 foreignborn
% 9 houseage
% 10 sales_emp
% 11 constr_emp
% 12 health_emp
% 13 fire_emp
% 14 traveltime
% 15 house_retired
% 16 retire_income
% 17 med_rent
% 18 med_mortgage
% 19 pc_income
% 20 pa_income
% 21 unemp
% 22 female_nowork
% 23 population in 1990

data = metro_census_1990(end-nmetro:end,:);

pop90 = log(data(:,23));
income90 = (data(:,19));
mort90 = (data(:,18));
travelt = (data(:,14));
% use logit transformation for the percentage of people in the same house 5 years ago
samehouse = log(data(:,7)./(ones(n,1)-data(:,7)));


latt = data(:,2);
long = data(:,3);

G = distance(latt,long);

gv = vec(G);
ind = find(gv > 0);
Glog = zeros(n*n,1);
Glog(ind,1) = log(gv(ind,1));

gmean = mean(Glog);

gdev = Glog - gmean;

Gdot = reshape(gdev,n,n);

dg = diag(Gdot);

clear G;

xmatrix = [pop90 income90 travelt samehouse];

vnamesd = strvcat('D_pop90','D_income90','D_traveltime90','D_samehouse');
vnameso = strvcat('O_pop90','O_income90','O_traveltime90','O_samehouse');
vnamesi = strvcat('I_pop90','I_income90','I_traveltime90','I_samehouse');


xmean = mean(xmatrix);

X = matsub(xmatrix,xmean);

[junk,k] = size(X);

load metroflows_2000.data;
flows = metroflows_2000(2:end,2:end);

Y = flows(end-nmetro:end,end-nmetro:end);

yvec = vec(Y);

ind = find(yvec > 0);
yvec(ind,1) = log(yvec(ind,1));

Y = reshape(yvec,n,n);

dy = diag(Y);

[ysort,ysind] = sort(yvec);

clear flows;

N = length(yvec);
n = sqrt(N);


% do spatial model
[j,W,j] = xy2cont(latt,long);


vnames = strvcat('log flows','constant','ia',vnamesd,vnameso,vnamesi,'distance');

% ==========================================================
% set-up stuff
% ==========================================================

miter = 10;
riter = 50;


traces = ftrace1(W,miter,riter);

Y = reshape(yvec,n,n);

iota = ones(n,1);
trd = iota'*(Gdot.*Gdot)*iota;


zpz = [N          n             zeros(1,k)         zeros(1,k)            zeros(1,k)  zeros(1,1)
       n          n             zeros(1,k)         zeros(1,k)            zeros(1,k)  trace(Gdot)
       zeros(k,1)  zeros(k,1)   n*X'*X             zeros(k,k)            X'*X        X'*Gdot*iota
       zeros(k,1)  zeros(k,1)   zeros(k,k)         n*X'*X                X'*X        X'*Gdot'*iota
       zeros(k,1)  zeros(k,1)   X'*X               X'*X                  X'*X        X'*dg 
       zeros(1,1)  trace(Gdot)   iota'*Gdot'*X      iota'*Gdot*X         dg'*X       trd];

[nvars,kk] = size(zpz);

% initial values for rho1,rho2,rho3
pvec=rand(3,1);
pvec=0.7*pvec/sum(pvec);%sum to 0.8
rho1 = pvec(1,1);
rho2 = pvec(2,1);
rho3 = pvec(3,1);

% set starting values to minimize burn-in
sige = 1.0;
% rho1 = 0.25;
% rho2 = 0.55;
% rho3 = 0.14;

ndraw = 1200;
nomit = 200;

tmp_in = ones(n*n,1);
Wbig = kron(speye(n),W);
Wddiag = (Wbig').*(Wbig')*tmp_in;
Wbig = kron(W,speye(n));
Wodiag = (Wbig').*(Wbig')*tmp_in;
Wbig = kron(W,W);
Wwdiag = (Wbig').*(Wbig')*tmp_in;


% storage for draws
          bsave = zeros(ndraw-nomit,nvars);
          psave = zeros(ndraw-nomit,3);
          ssave = zeros(ndraw-nomit,1);
          vmean = zeros(n*n,1);
          acc_rate = zeros(ndraw,3);

V = ones(n,n);
cc1 = 0.2;
cc2 = cc1;
cc3 = cc1;

acc1 = 0;
acc2 = 0;
acc3 = 0;

rmin = -1;
rmax = 1;


for iter = 1:ndraw;


%----------------------------------------
% update for beta starts here
%----------------------------------------

% beta1
iota = ones(n,1);

trdy = sum(sum(Gdot'.*Y));

   zpy = [iota'*Y*iota  
       trace(Y)
       X'*Y*iota   
       X'*Y'*iota 
       X'*dy 
       trdy];

   beta1 = (zpz\zpy);
   
   beta1 = norm_rnd(sige*(zpz\eye(kk))) + beta1;

    % these are needed to update sige and rho
    alpha = beta1(1,1);
    ai    = beta1(2,1);
    bd = beta1(3:3+k-1,1);
    bo = beta1(3+k:3+2*k-1,1);
    bi = beta1(3+2*k:3+3*k-1,1);
    gamma = beta1(end,1);

    xia = ia*ai;
    xdb = kron(iota,X)*bd;
    xob = kron(X,iota)*bo;
    xib =  matmul(vec(eye(n)),kron(iota,X))*bi;


    E = vec(Y) - ones(n*n,1)*alpha - xia - xdb - xob - xib - vec(Gdot)*gamma;

    E1 = reshape(E,n,n);

% beta 2
WY = W*Y;
% ---------------------------------------------

   trdy = sum(sum(Gdot'.*WY));
   
   zpy = [iota'*WY*iota  
       trace(WY)
       X'*WY*iota   
       X'*WY'*iota 
       X'*diag(WY)
       trdy];

    beta2 = (zpz\zpy);

    beta2 = norm_rnd(sige*(zpz\eye(kk))) + beta2;

    % these are needed to update sige and rho
    alpha = beta2(1,1);
    ai    = beta2(2,1);
    bd = beta2(3:3+k-1,1);
    bo = beta2(3+k:3+2*k-1,1);
    bi = beta2(3+2*k:3+3*k-1,1);
    gamma = beta2(end,1);

    xia = ia*ai;
    xdb = kron(iota,X)*bd;
    xob = kron(X,iota)*bo;
    xib =  matmul(vec(eye(n)),kron(iota,X))*bi;

    E = vec(WY) - ones(n*n,1)*alpha - xia - xdb - xob - xib - vec(Gdot)*gamma;

    E2 = reshape(E,n,n);

% beta 3
WY = Y*W';
% ---------------------------------------------

   trdy = sum(sum(Gdot'.*WY));
   
   zpy = [iota'*WY*iota  
       trace(WY)
       X'*WY*iota   
       X'*WY'*iota 
       X'*diag(WY)
       trdy];

    beta3 = (zpz\zpy);

    beta3 = norm_rnd(sige*(zpz\eye(kk))) + beta3;
    % these are needed to update sige and rho
    alpha = beta3(1,1);
    ai    = beta3(2,1);
    bd = beta3(3:3+k-1,1);
    bo = beta3(3+k:3+2*k-1,1);
    bi = beta3(3+2*k:3+3*k-1,1);
    gamma = beta3(end,1);

    xia = ia*ai;
    xdb = kron(iota,X)*bd;
    xob = kron(X,iota)*bo;
    xib =  matmul(vec(eye(n)),kron(iota,X))*bi;

    E = vec(WY) - ones(n*n,1)*alpha - xia - xdb - xob - xib - vec(Gdot)*gamma;

    E3 = reshape(E,n,n);

% beta 4
WY = W*Y*W';
% ---------------------------------------------
   trdy = sum(sum(Gdot'.*WY));
   
   zpy = [iota'*WY*iota  
       trace(WY)
       X'*WY*iota   
       X'*WY'*iota 
       X'*diag(WY)
       trdy];

    beta4 = (zpz\zpy);
    beta4 = norm_rnd(sige*(zpz\eye(kk))) + beta4;

    % these are needed to update sige and rho
    alpha = beta4(1,1);
    ai    = beta4(2,1);
    bd = beta4(3:3+k-1,1);
    bo = beta4(3+k:3+2*k-1,1);
    bi = beta4(3+2*k:3+3*k-1,1);
    gamma = beta4(end,1);

    xia = ia*ai;
    xdb = kron(iota,X)*bd;
    xob = kron(X,iota)*bo;
    xib =  matmul(vec(eye(n)),kron(iota,X))*bi;

    E = vec(WY) - ones(n*n,1)*alpha - xia - xdb - xob - xib - vec(Gdot)*gamma;

    E4 = reshape(E,n,n);


tau = [1
       -rho1
       -rho2
       -rho3];
   
beta = [beta1 beta2 beta3 beta4]*tau;

%----------------------------------------
% update for beta ends here
%----------------------------------------

%----------------------------------------
% update for sige starts here
%----------------------------------------
Q = zeros(4,4);

Q(1,1) = sum(sum(E1.*E1));
Q(1,2) = sum(sum(E1.*E2));
Q(1,3) = sum(sum(E1.*E3));
Q(1,4) = sum(sum(E1.*E4));
Q(2,1) = Q(1,2);
Q(3,1) = Q(1,3);
Q(4,1) = Q(1,4);
Q(2,2) = sum(sum(E2.*E2));
Q(2,3) = sum(sum(E2.*E3));
Q(2,4) = sum(sum(E2.*E4));
Q(3,2) = Q(2,3);
Q(4,2) = Q(2,4);
Q(3,3) = sum(sum(E3.*E3));
Q(3,4) = sum(sum(E3.*E4));
Q(4,3) = Q(3,4);
Q(4,4) = sum(sum(E4.*E4));

epe = tau'*Q*tau;

% sum of squared errors is tau'*Q*tau;

          epe = tau'*Q*tau;
          nu = 0; d0 = 0;
          nu1 = n*n + 2*nu; 
          d1 = 2*d0 + epe;
          chi = chis_rnd(1,nu1);
          sige = d1/chi;

%----------------------------------------
% update for sige ends here
%----------------------------------------

%----------------------------------------
% update for rho1,rho2,rho3 starts here
%----------------------------------------

          % update rho1 using metropolis-hastings
          rhox = c_sarf(rho1,rho2,rho3,sige,Q,traces,n,nvars);
          accept = 0;
          rho1c = rho1 + cc1*randn(1,1);
          while accept == 0
          rhosum = rho1c + rho2 + rho3; % stability condition imposed using rejection sampling
           if ((rho1c > rmin) & (rho1c < rmax) & (rhosum < rmax)); 
           accept = 1;  
           else
           rho1c = rho1 + cc1*randn(1,1);
           end; 
          end; 
           rhoy = c_sarf(rho1c,rho2,rho3,sige,Q,traces,n,nvars);
          ru = unif_rnd(1,0,1);
          if ((rhoy - rhox) > exp(1)),
          p = 1;
          else,          
          ratio = exp(rhoy-rhox);
          p = min(1,ratio);
          end;
              if (ru < p)
              rho1 = rho1c;
              acc1 = acc1 + 1;
              end;
      acc_rate(iter,1) = acc1/iter;
      % update cc based on std of rho draws
       if acc_rate(iter,1) < 0.4
       cc1 = cc1/1.1;
       end;
       if acc_rate(iter,1) > 0.6
       cc1 = cc1*1.1;
       end;
       
          % update rho2 using metropolis-hastings
          rhox = c_sarf(rho1,rho2,rho3,sige,Q,traces,n,nvars);
          accept = 0;
          rho2c = rho2 + cc2*randn(1,1);
          while accept == 0
          rhosum = rho1 + rho2c + rho3; % stability condition imposed using rejection sampling
           if ((rho2c > rmin) & (rho2c < rmax) & (rhosum < rmax)); 
           accept = 1;  
           else
           rho2c = rho2 + cc2*randn(1,1);
           end; 
          end; 
          rhoy = c_sarf(rho1,rho2c,rho3,sige,Q,traces,n,nvars);
          ru = unif_rnd(1,0,1);
          if ((rhoy - rhox) > exp(1)),
          p = 1;
          else,          
          ratio = exp(rhoy-rhox);
          p = min(1,ratio);
          end;
              if (ru < p)
              rho2 = rho2c;
              acc2 = acc2 + 1;
              end;
      acc_rate(iter,2) = acc2/iter;
      % update cc based on std of rho draws
       if acc_rate(iter,2) < 0.4
       cc2 = cc2/1.1;
       end;
       if acc_rate(iter,2) > 0.6
       cc2 = cc2*1.1;
       end;

       if model == 3
           rho3 = 0;
       elseif model == 2
           rho3 = -rho1*rho2;
       else
          % update rho3 using metropolis-hastings
          rhox = c_sarf(rho1,rho2,rho3,sige,Q,traces,n,nvars);
          accept = 0;
          rho3c = rho3 + cc3*randn(1,1);
          while accept == 0
           rhosum = rho1 + rho2 + rho3c; % stability condition imposed using rejection sampling
           if ((rho2c > rmin) & (rho2c < rmax) & (rhosum < rmax)); 
           accept = 1;  
           else
           rho3c = rho3 + cc3*randn(1,1);
           end; 
          end; 
          rhoy = c_sarf(rho1,rho2,rho3c,sige,Q,traces,n,nvars);
          ru = unif_rnd(1,0,1);
          if ((rhoy - rhox) > exp(1)),
          p = 1;
          else,          
          ratio = exp(rhoy-rhox);
          p = min(1,ratio);
          end;
              if (ru < p)
              rho3 = rho3c;
              acc3 = acc3 + 1;
              end;
      acc_rate(iter,3) = acc3/iter;
      % update cc based on std of rho draws
       if acc_rate(iter,3) < 0.4
       cc3 = cc3/1.1;
       end;
       if acc_rate(iter,3) > 0.6
       cc3 = cc3*1.1;
       end;
       end;

%----------------------------------------
% update for rho1,rho2,rho3 ends here
%----------------------------------------
      

    if iter > nomit % if we are past burn-in, save the draws
    bsave(iter-nomit,:) = beta';
    ssave(iter-nomit,1) = sige;
    psave(iter-nomit,1) = rho1;
    psave(iter-nomit,2) = rho2;
    psave(iter-nomit,3) = rho3;
    
tt=1:iter-nomit;
subplot(3,2,1),
plot(tt,bsave(tt,2:end),'.');
title('beta draws');
subplot(3,2,2),
plot(tt,ssave(tt,1),'.');
title('sigma draws');
subplot(3,2,3),
plot(tt,bsave(tt,1),'.');
title('constant term');
subplot(3,2,4),
plot(tt,psave(tt,1),'.');
title('rho1 draws');
subplot(3,2,5),
plot(tt,psave(tt,2),'.');
title('rho2 draws');
subplot(3,2,6),
plot(tt,psave(tt,3),'.');
title('rho3 draws');
drawnow;

    end;
                    
iter = iter + 1; 
waitbar(iter/ndraw);         
end; % end of sampling loop


smean = mean(ssave);

disp('posterior mean of sige');
smean

[nn,k] = size(xmatrix);

bounds = hpdi2(bsave,0.95);
pbounds = hpdi2(psave,0.95);

bmean = mean(bsave);
rhom = mean(psave);
rhos = std(psave);

rhot = rhom./rhos;

bstd = std(bsave);

btstat = bmean./bstd;

out = [bmean' bounds
       rhom(1,1) pbounds(1,:)
       rhom(1,2) pbounds(2,:)
       rhom(1,3) pbounds(3,:)];
   
in2.rnames = strvcat(vnames,'rho1','rho2','rho3');
in2.cnames = strvcat('coefficients','lower 0.05','upper 0.95');
mprint(out,in2);


