% calculate effects estimates
% for O-D spatial autoregressive flow model

clear all;

load wmatrix.data;

W = sparse(wmatrix);
[n,junk] = size(W);
N = n*n;

Wd = kron(speye(n),W);
Wo = kron(W,speye(n));
Ww = kron(W,W);


load bdraws.data;
% first is constant term
% next k are betad
% next k are betao
% final is distance

[junk,kp1] = size(bdraws);

k = (kp1 - 2)/2;

[ndraws,junk] = size(bdraws);

nomit = 4500; %needs to be adjusted to produce 1,000 draws that are used
% ndraws in my case were 5500

betad = bdraws(nomit+1:ndraws,2:2+k-1);
betao = bdraws(nomit+1:ndraws,2+k:2+2*k-1);
 


load pdraws.data;
% first is rhod
% second is rhoo
% third is rhow

rho = pdraws(nomit+1:ndraws,:);

rho_d = rho(:,1);
rho_o = rho(:,2);
rho_w = rho(:,3);

niter = length(rho);

iotan = ones(n,1);


N = n*n;


iotan = ones(n,1);
iotan2 = ones(n*n,1);

imat_save = [];
dmat_save = [];
omat_save = [];
tmp = ones(n,n);
    cnt = 1;
    tt=1:n;
    
            
for j=1:n;
imat = zeros(n,n);
dmat = zeros(n,n);
omat = zeros(n,n);

                if cnt == n+1;
                    cnt = 1;
                end;

            indi = find(tt ~= cnt);
            dmat(cnt,indi) = 1;
dmat_save = [dmat_save
             dmat];
            omat(indi,cnt) = 1;
omat_save = [omat_save
             omat];
            imat(cnt,cnt) = 1;
imat_save = [imat_save
             imat];

cnt = cnt+1;
end;


in.fmt = '%8.4f';
in.width = 1000;


out_omean = zeros(niter,k);
out_dmean = zeros(niter,k);
out_nmean = zeros(niter,k);
out_imean = zeros(niter,k);
out_tmean = zeros(niter,k);


for iter=1:niter;
tic;

rho1 = rho_d(iter,1);
rho2 = rho_o(iter,1);
rho3 = rho_w(iter,1);
    
    for p=1:k;

    betadi = betad(iter,p);
    betaoi = betao(iter,p);

tmp = zeros(N,n);
tmp(dmat_save == 1) = betadi;
tmp(omat_save == 1) = betaoi;
tmp(imat_save == 1) = betadi + betaoi;

tmp = (speye(n*n) - rho1*Wd - rho2*Wo - rho3*Ww)\tmp;
total = (1/N)*iotan2'*tmp*iotan;

tmpi = zeros(N,n);
tmpi(imat_save == 1) = tmp(imat_save == 1);
intra = (1/N)*iotan2'*tmpi*iotan;

tmpo = zeros(N,n);
tmpo(omat_save == 1) = tmp(omat_save == 1);
orig = (1/N)*iotan2'*tmpo*iotan;

tmpd = zeros(N,n);
tmpd(dmat_save == 1) = tmp(dmat_save == 1);
dest = (1/N)*iotan2'*tmpd*iotan;

tmpn = tmp - tmpi - tmpo - tmpd;

netw = total - orig - dest - intra;

out = [orig dest intra netw  total orig+dest+intra+netw];
in.cnames = strvcat('origin', 'destination', 'intra', 'network', 'total', 'total_check');
mprint(out,in);

out_omean(iter,p) = orig;
out_dmean(iter,p) = dest;
out_nmean(iter,p) = netw;
out_imean(iter,p) = intra;
out_tmean(iter,p) = total;

end; % end of for p loop


iter   
toc;
end; % end of iter loop


omean_out = mean(out_omean);
omedian_out = median(out_omean);
ostd_out = std(out_omean);
obounds = hpdi2(out_omean,0.95);

print_out = [omean_out' omedian_out' ostd_out' obounds];

vnames = strvcat('workers residence','jobs location');


in.rnames = strvcat('Variables',vnames);
in.cnames = strvcat('origin mean','median','origin std','lower 0.05','upper 0.95');
mprint(print_out,in);

dmean_out = mean(out_dmean);
dmedian_out = median(out_dmean);
dstd_out = std(out_dmean);
dbounds = hpdi2(out_dmean,0.95);

print_out = [dmean_out' dmedian_out' dstd_out'  dbounds];
in.cnames = strvcat('destination mean','median','destination std','lower 0.05','upper 0.95');
mprint(print_out,in);

nmean_out = mean(out_nmean);
nmedian_out = median(out_nmean);
nstd_out = std(out_nmean);
nbounds = hpdi2(out_nmean,0.95);

print_out = [nmean_out' nmedian_out' nstd_out' nbounds];
in.cnames = strvcat('network mean','median','network std','lower 0.05','upper 0.95');
mprint(print_out,in);

imean_out = mean(out_imean);
imedian_out = median(out_imean);
istd_out = std(out_imean);
ibounds = hpdi2(out_imean,0.95);

print_out = [imean_out' imedian_out' istd_out' ibounds ];
in.cnames = strvcat('intra mean','intra median','intra std','lower 0.05','upper 0.95');
mprint(print_out,in);

tmean_out = mean(out_tmean);
tmedian_out = median(out_tmean);
tstd_out = std(out_tmean);
tbounds = hpdi2(out_tmean,0.95);

print_out = [tmean_out' tmedian_out' tstd_out' tbounds];
in.cnames = strvcat('total mean','total_median','total std','lower 0.05','upper 0.95');
mprint(print_out,in);

