function llike = f2_sarfm(parm,Q,n,k,kk,traces,W,miter,riter,model,X,Gdot,Y)
% PURPOSE: evaluates concentrated log-likelihood for the 
%  spatial autoregressive flow model using sparse matrix algorithms
% ---------------------------------------------------
%  USAGE:llike = f_sarf(rvec,epe,epeo,eped,epew,epedo,epewo,epewd,n,model)
%  where: rvec  = a vector of three spatial autoregressive parameters
%                 rho1,rho2,rho3
%         Q, a 4 by 4 matrix
%         n      = # of obs
%         W      = spatial weight matrix
% ---------------------------------------------------
%  RETURNS: a  scalar equal to minus the log-likelihood
%           function value at the parameter vector for rho1,rho2,rho3
% ---------------------------------------------------                         
%  NOTE: this is really many functions depending
%        on the model flag setting (see the function)
%  --------------------------------------------------
%  SEE ALSO: sar, f_far, f_sac, f_sem
% ---------------------------------------------------

% written by: James P. LeSage 5/2005
% University of Toledo
% Department of Economics
% Toledo, OH 43606
% jlesage@spatial-econometrics.com


beta = parm(1:kk,1);


    alpha = beta(1,1);
    ai    = beta(2,1);
    bd = beta(3:3+k-1,1);
    bo = beta(3+k:3+2*k-1,1);
    bi = beta(3+2*k:3+3*k-1,1);
    gamma = beta(end,1);



rho1 = parm(kk+1,1);
rho2 = parm(kk+2,1);
rho3 = parm(kk+3,1);
sige = parm(kk+4,1);


rvec = [rho1
        rho2
        rho3];
        
logdet = fodet1(rvec,traces,n);


% compute e'*e
iota = ones(n,1);
ia = vec(eye(n));

    xia = ia*ai;
    xdb = kron(iota,X)*bd;
    xob = kron(X,iota)*bo;
    xib =  matmul(vec(eye(n)),kron(iota,X))*bi;


Wy1 = vec(W*Y);
Wy2 = vec(Y*W');
Wy3 = vec(W*Y*W');

e = vec(Y) -rho1*Wy1 - rho2*Wy2 - rho3*Wy3 - ones(n*n,1)*alpha - xia - xdb - xob - - xib - vec(Gdot)*gamma;

epe2 = e'*e;

tmp2 = 1/(2*sige);
nn = n*n;
llike = -(nn/2)*log(pi) - (nn/2)*log(sige) + logdet - tmp2*epe2;

