function llike = f_sarfm(pvec,Q,n,traces,W,miter,riter,model,ldetflag)
% PURPOSE: evaluates concentrated log-likelihood for the 
%  spatial autoregressive flow model using sparse matrix algorithms
% ---------------------------------------------------
%  USAGE:llike = f_sarf(rvec,epe,epeo,eped,epew,epedo,epewo,epewd,n,model)
%  where: rvec  = a vector of three spatial autoregressive parameters
%                 rho1,rho2,rho3
%         Q, a 4 by 4 matrix
%         n      = # of obs
%         W      = spatial weight matrix
% ---------------------------------------------------
%  RETURNS: a  scalar equal to minus the log-likelihood
%           function value at the parameter vector for rho1,rho2,rho3
% ---------------------------------------------------                         
%  NOTE: this is really many functions depending
%        on the model flag setting (see the function)
%  --------------------------------------------------
%  SEE ALSO: sar, f_far, f_sac, f_sem
% ---------------------------------------------------

% written by: James P. LeSage 5/2005
% University of Toledo
% Department of Economics
% Toledo, OH 43606
% jlesage@spatial-econometrics.com


if model == 1
        
rho1 = pvec(1,1);
rho2 = pvec(2,1);
rho3 = pvec(3,1);

rvec = [rho1
        rho2
        rho3];
    
if sum(rvec) > 1
   llike = 1e+6;
   return;
end;
        
logdet = fodet1(rvec,traces,n);

rhovec = [1
        -rho1
        -rho2
        -rho3];
    

z = rhovec'*Q*rhovec;
nn = n*n;

llike = (nn/2)*log(z) - logdet;

llike = real(llike);


elseif model == 2
rho1 = pvec(1,1);
rho2 = pvec(2,1);
rho3 = -pvec(1,1)*pvec(2,1);

rvec = [rho1
        rho2
        rho3];
        
   logdet = fodet1(rvec,traces,n);

rhovec = [1
        -rho1
        -rho2
         rho3];
    

z = rhovec'*Q*rhovec;
nn = n*n;
llike = (nn/2)*log(z) - logdet;

llike = real(llike);


elseif model == 3
rho1 = pvec(1,1);
rho2 = pvec(2,1);
rho3 = 0.0;

rvec = [rho1
        rho2
        rho3];
        
   logdet = fodet1(rvec,traces,n);

rhovec = [1
        -rho1
        -rho2
        -rho3];
    

z = rhovec'*Q*rhovec;
nn = n*n;
llike = (nn/2)*log(z) - logdet;

llike = real(llike)

llike

end;


