function logdet=fodet1(parms,traces,n)
%
%function logdet=fodet1(parms,traces,n)
%
%Given a 3x1 parameter vector parms comprised of unequal scalars with a sum of less than 1, this function
%computes the log-determinant of an Origin-Destination weight matrix W such as,
%W=parm(1)*kron(w,eyen)+parm(2)*kron(eyen,w)+parm(3)*kron(w,w) where w is a spatial weight matrix with maximum
%eigenvalue of 1, and diagonal with zeros. The spatial weight matrix w is nxn while W is n-squaredXn-squared.
%
%Inputs: parms -- a 3x1 parameter vector parms comprised of unequal scalars with a sum of less than 1
%        traces -- the first miter traces of w
%        n -- one of the dimensions of w (as opposed to W which has dimensions n-squared by n-squared
%
%Output: a scalar real log-determinant
%
%Kelley Pace, spatial-statistics.com, 5/5/05


miter=length(traces);%highest order trace supplied to the routine

tw=[traces;n];%append an n at the end -- necessary since matlab does not allow the more logical tw(0)=n=trace(w^0)

op=ones(3,1);%used for kronecker products

%bign=3^miter;%largest number of terms used

titer=800;%maximum order trace
rez=zeros(titer,2);
rez(1,1)=1;
p=parms;
vvv=p;%initializing variable modified in loop
for miteri=2:miter%goes to the maximum supplied trace
    vvv=[kron(vvv,op) kron(ones(3^(miteri-1),1),p)];%sets up all parameter combinations


vi=(vvv==p(1));%finds instances where i was used
vj=(vvv==p(2));%finds instances where j was used
vk=(vvv==p(3));%finds instances where k was used

vprod=prod(vvv,2);%product of all parameters

vis=sum(vi,2);%summing all i terms
vjs=sum(vj,2);%summing all j terms
vks=sum(vk,2);%summing all k terms

va=vis+vks;%in formula relevant power is i+k
vb=vjs+vks;%in formula relevant power is j+k

vaind=(va==0);%must allow for zero powers separately
vbind=(vb==0);%must allow for zero powers separately

vaa=va+vaind*(miter+1);%allowing zero powers separately
vbb=vb+vbind*(miter+1);%allowing zero powers separately

ts=tw(vaa).*tw(vbb);%the trace of a Kronecker product is the product of the traces


tparts=vprod.*ts;%weighting the traces by the parameter products

tracei=sum(tparts);%sum of all contributions to the trace

rez(miteri,:)=[miteri tracei/miteri];%storing the trace/index as used in matrix log

end

scalarparm=sum(p);%for row-stochastic w, this will be the max eigenvalue of W

ti=tracei;%last computed trace
for miteri=(miter+1):titer%going past computed traces to titer terms;
    ti=scalarparm*ti;%upper bound of possible trace
    rez(miteri,:)=[miteri ti/miteri];%storing upper bound trace/index
   
end


logdet=-sum(rez(:,2));%appling tr(matrix log) formula











