% do MCMC vi-model using moment matrix approach

clear all;

% PURPOSE: Run Bayesian flow model

clear all;

% ======================================
% load data from files

load latt_long.data;

latt = latt_long(:,1);
long = latt_long(:,2);
area = latt_long(:,3);


% dmatrix = distance(latt,long);
% 
% dvec = log(vec(dmatrix)+1);


[a,b] = xlsread('flux_district_S.xls');

index = strvcat(b(2:end,1));

indexo = str2num(index(:,1:5));

index = strvcat(b(2:end,2));

indexd = str2num(index(:,1:5));

n = 60;

flows = zeros(n,n);
cnt = 1;
for i=1:n
for j=1:n;
indj = find(indexd(cnt,1) == j);
indi = find(indexo(cnt,1) == i);
if (length(indj) > 0 & length(indi) > 0)
flows(j,i) = a(cnt,1);
cnt = cnt+1;
end;
end;
end;

yvec = vec(flows);

y = log(yvec+1);


[a,b] = xlsread('distance_district.xls');

dvec = a(:,3);

[a,b] = xlsread('X_district.xls');

xdest = [log(a(:,1)) log(a(:,2))];

X = xdest;

% x1 = working population
% x2 = employment

vnamesd = strvcat('D_laborforce','D_employment');

vnameso = strvcat('O_laborforce','O_employment');

[n,nvars] = size(xdest);

% repeat this x-matrix n times
xd = []; % destination characteristics
for i=1:n;
    xd = [xd
          xdest];
end;

xo = []; % origin characteristics
for i=1:n;
    xo = [xo
          matmul(xdest(i,:),ones(n,nvars))];
end;

N = length(y);
n = sqrt(N);

xmatrix = [xd xo dvec];

k = nvars;

result = ols(y,[ones(N,1) xmatrix ]);


vnames = strvcat('cflows','constant',vnamesd, vnameso, ...
    'log(distance)');

prt(result,vnames);

gvec = xmatrix(:,end);
G = reshape(gvec,n,n);

gmean = mean(gvec);

Gdot = G - gmean;

x = [ones(N,1) xmatrix(:,1:end-1) vec(Gdot)];

% do spatial model
%[j,W,j] = xy2cont(latt,long);

W = make_neighborsw(latt,long,6);

Wd = kron(eye(n),W);
Wo = kron(W,eye(n));
Ww = kron(W,W);

% options.model = 1;
% options.lflag = 0;

vnames = strvcat('log flows','constant',vnamesd,vnameso,'distance');

% ==========================================================
% set-up stuff
% ==========================================================

miter = 10;
riter = 50;

model = 1;

if model == 1
traces = ftrace1(W,miter,riter);
pvec=rand(3,1);
pvec=0.7*pvec/sum(pvec);%sum to 0.8

elseif model == 2
traces = ftrace1(W,miter,riter);
tmp=rand(2,1);
tmp=0.7*tmp/sum(tmp);%sum to 0.8
pvec = tmp;

elseif model == 3
traces = ftrace1(W,miter,riter);
tmp=rand(2,1);
tmp=0.7*tmp/sum(tmp);%sum to 0.8
pvec = tmp;
end;

Y = reshape(y,n,n);

iota = ones(n,1);
trd = iota'*(Gdot.*Gdot)*iota;

xmean = mean(X);
Xdot = matsub(X,xmean);

% initial values for rho1,rho2,rho3
pvec=rand(3,1);
pvec=0.7*pvec/sum(pvec);%sum to 0.8
rho1 = pvec(1,1);
rho2 = pvec(2,1);
rho3 = pvec(3,1);

ndraw = 5500;
nomit = 2500;

[junk,nvars] = size(xmatrix);
nvars = nvars+1;
% storage for draws
          bsave = zeros(ndraw-nomit,nvars);
          psave = zeros(ndraw-nomit,3);
          ssave = zeros(ndraw-nomit,1);
          vmean = zeros(n*n,1);
          acc_rate = zeros(ndraw,3);

          total_effect = zeros(ndraw-nomit,k-1); % k-1 to exclude the intercept term
          origin_effect = zeros(ndraw-nomit,k-1);
          destination_effect = zeros(ndraw-nomit,k-1);
          indirect_effect = zeros(ndraw-nomit,k-1);
          intra_effect = zeros(ndraw-nomit,k-1);



V = ones(n,n);
sige = 1;
cc1 = 0.2;
cc2 = cc1;
cc3 = cc1;

acc1 = 0;
acc2 = 0;
acc3 = 0;

rmin = -1;
rmax = 1;

%effects_flag = 0;
constraint_flag = 0;

for iter = 1:ndraw;


%----------------------------------------
% update for beta starts here
%----------------------------------------
% test memory-saving sum for z'*S*z
%                     and z'*S*y

WY = W*Y;
YW = Y*W';
WYW = W*Y*W';
zpzt = zeros(nvars,nvars);
zpzty1 = zeros(nvars,1);
zpzty2 = zeros(nvars,1);
zpzty3 = zeros(nvars,1);
zpzty4 = zeros(nvars,1);

bmean1 = zeros(nvars,1);
bmean2 = zeros(nvars,1);
bmean3 = zeros(nvars,1);
bmean4 = zeros(nvars,1);
cnt = 1;

for i=1:n;
z = x(cnt:cnt+n-1,:);
fy = [Y(:,i) WY(:,i) YW(:,i) WYW(:,i)];
p = sqrt(V(:,i));
zt = matmul(p,z);
zpzt = zpzt + zt'*zt;
zpzty1 = zpzty1 + zt'*fy(:,1);
zpzty2 = zpzty2 + zt'*fy(:,2);
zpzty3 = zpzty3 + zt'*fy(:,3);
zpzty4 = zpzty4 + zt'*fy(:,4);
cnt = cnt+n;
end;
zpzti = zpzt\eye(nvars);
bdraw1 = norm_rnd(sige*zpzti) + zpzti*zpzty1;
bdraw2 = norm_rnd(sige*zpzti) + zpzti*zpzty2;
bdraw3 = norm_rnd(sige*zpzti) + zpzti*zpzty3;
bdraw4 = norm_rnd(sige*zpzti) + zpzti*zpzty4;

tau = [1
       -rho1
       -rho2
       -rho3];
   
beta = [bdraw1 bdraw2 bdraw3 bdraw4]*tau;

%----------------------------------------
% update for beta ends here
%----------------------------------------

%----------------------------------------
% update for sige starts here
%----------------------------------------
alpha = beta(1,1);
bd = beta(2:2+k-1,1);
bo = beta(2+k:2+k+k-1,1);
gamma = beta(end,1);

xob = kron(iota,Xdot*bd);
xdb = kron(Xdot*bo,iota);

% Xo*b=kron(iota,X)bo=kron(iota,X*bo).
% similarly kron(X,iota)bd=kron(X*bd,iota)
% The other two parameters are vectors and thus no problem. iota_N*alpha,
% vec(D)*gamma=vec(D*gamma)
% Also, if you don't use y but use the matrix Y, you can find the residual
% matrix E as in equation 10 and then vectorize the residuals.

yhat = ones(n*n,1)*alpha + xob + xdb + vec(Gdot)*gamma;
% note these are untransformed e's because we
% are using z, not p*z
E1 = reshape(vec(Y) - yhat,n,n);
E2 = reshape(vec(WY) - yhat,n,n);
E3 = reshape(vec(YW) - yhat,n,n);
E4 = reshape(vec(WYW) - yhat,n,n);

% transform E's
% 
% for i=1:n;
% p = sqrt(V(:,i));
% E1(:,i) = p.*E1u(:,i);
% E2(:,i) = p.*E2u(:,i);
% E3(:,i) = p.*E3u(:,i);
% E4(:,i) = p.*E4u(:,i);
% end;


Q = zeros(4,4);

Q(1,1) = sum(sum(E1.*E1));
Q(1,2) = sum(sum(E1.*E2));
Q(1,3) = sum(sum(E1.*E3));
Q(1,4) = sum(sum(E1.*E4));
Q(2,1) = Q(1,2);
Q(3,1) = Q(1,3);
Q(4,1) = Q(1,4);
Q(2,2) = sum(sum(E2.*E2));
Q(2,3) = sum(sum(E2.*E3));
Q(2,4) = sum(sum(E2.*E4));
Q(3,2) = Q(2,3);
Q(4,2) = Q(2,4);
Q(3,3) = sum(sum(E3.*E3));
Q(3,4) = sum(sum(E3.*E4));
Q(4,3) = Q(3,4);
Q(4,4) = sum(sum(E4.*E4));

% sum of squared errors is tau'*Q*tau;

          epe = tau'*Q*tau;
          nu = 0; d0 = 0;
          nu1 = n*n + 2*nu; 
          d1 = 2*d0 + epe;
          chi = chis_rnd(1,nu1);
          sige = d1/chi;

%----------------------------------------
% update for sige ends here
%----------------------------------------

%----------------------------------------
% update for vi variance scalars starts here
%----------------------------------------
%rval = 4;
in = ones(n*n,1);

% use untransformed E's here
% E = E1u - rho1*E2u - rho2*E3u - rho3*E4u;
% 
% ee = vec(E.*E);
 
%           chiv = chis_rnd(n*n,rval+1);   
%           vi = ((ee/sige) + in*rval)./chiv;
%           V = reshape(in./vi,n,n);

%----------------------------------------
% update for vi variance scalars ends here
%----------------------------------------

%----------------------------------------
% update for rho1,rho2,rho3 starts here
%----------------------------------------

          % update rho1 using metropolis-hastings
          rhox = c_sarf(rho1,rho2,rho3,sige,Q,traces,n,nvars);
          accept = 0;
          rho1c = rho1 + cc1*randn(1,1);
          while accept == 0
           if ((rho1c > rmin) && (rho1c < rmax)); 
           accept = 1;  
           else
           rho1c = rho1 + cc1*randn(1,1);
           end; 
          end; 
           rhoy = c_sarf(rho1c,rho2,rho3,sige,Q,traces,n,nvars);
          ru = unif_rnd(1,0,1);
          if ((rhoy - rhox) > exp(1)),
          p = 1;
          else          
          ratio = exp(rhoy-rhox);
          p = min(1,ratio);
          end;
              if (ru < p)
              rho1 = rho1c;
              acc1 = acc1 + 1;
              end;
      acc_rate(iter,1) = acc1/iter;
      % update cc based on std of rho draws
       if acc_rate(iter,1) < 0.4
       cc1 = cc1/1.1;
       end;
       if acc_rate(iter,1) > 0.6
       cc1 = cc1*1.1;
       end;
       
          % update rho2 using metropolis-hastings
          rhox = c_sarf(rho1,rho2,rho3,sige,Q,traces,n,nvars);
          accept = 0;
          rho2c = rho2 + cc2*randn(1,1);
          while accept == 0
           if ((rho2c > rmin) && (rho2c < rmax)); 
           accept = 1;  
           else
           rho2c = rho2 + cc2*randn(1,1);
           end; 
          end; 
          rhoy = c_sarf(rho1,rho2c,rho3,sige,Q,traces,n,nvars);
          ru = unif_rnd(1,0,1);
          if ((rhoy - rhox) > exp(1)),
          p = 1;
          else          
          ratio = exp(rhoy-rhox);
          p = min(1,ratio);
          end;
              if (ru < p)
              rho2 = rho2c;
              acc2 = acc2 + 1;
              end;
      acc_rate(iter,2) = acc2/iter;
      % update cc based on std of rho draws
       if acc_rate(iter,2) < 0.4
       cc2 = cc2/1.1;
       end;
       if acc_rate(iter,2) > 0.6
       cc2 = cc2*1.1;
       end;

          % update rho3 using metropolis-hastings
          rhox = c_sarf(rho1,rho2,rho3,sige,Q,traces,n,nvars);
          accept = 0;
          rho3c = rho3 + cc3*randn(1,1);
          while accept == 0
           if ((rho3c > rmin) && (rho3c < rmax)); 
           accept = 1;  
           else
           rho3c = rho3 + cc3*randn(1,1);
           end; 
          end; 
          rhoy = c_sarf(rho1,rho2,rho3c,sige,Q,traces,n,nvars);
          ru = unif_rnd(1,0,1);
          if ((rhoy - rhox) > exp(1)),
          p = 1;
          else        
          ratio = exp(rhoy-rhox);
          p = min(1,ratio);
          end;
              if (ru < p)
              rho3 = rho3c;
              acc3 = acc3 + 1;
              end;
      acc_rate(iter,3) = acc3/iter;
      % update cc based on std of rho draws
       if acc_rate(iter,3) < 0.4
       cc3 = cc3/1.1;
       end;
       if acc_rate(iter,3) > 0.6
       cc3 = cc3*1.1;
       end;


%----------------------------------------
% update for rho1,rho2,rho3 ends here
%----------------------------------------


% end; % end of if effects_flag == 1
      
% debug display stuff
%[iter rho1 rho2 rho3 sige]


    %if iter > nomit % if we are past burn-in, save the draws
    bsave(iter,:) = beta';
    ssave(iter,1) = sige;
    psave(iter,1) = rho1;
    psave(iter,2) = rho2;
    psave(iter,3) = rho3;
    %vmean = vmean + vi;
    %end;

% tt=1:iter;
% plot(tt,psave(tt,:));
% legend('rho1','rho2','rho3');
% drawnow;

                    
waitbar(iter/ndraw);         
end; % end of sampling loop

%vmean = vmean/(ndraw-nomit);

smean = mean(ssave);

disp('posterior mean of sige');
smean

[nn,k] = size(xmatrix);

bounds = hpdi2(bsave,0.95);
pbounds = hpdi2(psave,0.05);

bmean = mean(bsave);
rhom = mean(psave);
rhos = std(psave);

rhot = rhom./rhos;

bstd = std(bsave);

btstat = bmean./bstd;

out = [bmean' bounds
       rhom(1,1) pbounds(1,:)
       rhom(1,2) pbounds(2,:)
       rhom(1,3) pbounds(3,:)];
   
in2.rnames = strvcat(vnames,'rho1','rho2','rho3');
in2.cnames = strvcat('coefficients','lower 0.05','upper 0.95');
mprint(out,in2);

out = [bmean' btstat'
       rhom' rhot'];

in3.rnames = strvcat(vnames,'rho1','rho2','rho3');
in3.cnames = strvcat('coefficients','t-stat');
mprint(out,in3);




% % parse vi-means into a O-D flow table
% viout = [];
% for i=1:n:n*n;
%     viout = [viout vmean(i:i+n-1,1)];
% end;
% 
%     
% % write out to a file
% in5.fid = fopen('viout.data','w');
% 
% in5.width = 5000;
% 
% mprint(viout,in5);
% 
% fclose(in5.fid);

% save the draws
in5.fid = fopen('bdraws.data','w');

mprint(bsave,in5);

fclose(in5.fid);

in5.fid = fopen('pdraws.data','w');

mprint(psave,in5);

fclose(in5.fid);

in5.fid = fopen('sdraws.data','w');

mprint(ssave,in5);

fclose(in5.fid);


in.fid = fopen('wmatrix.data','w');
in.fmt = '%12.4f';
in.width = 10000;

mprint(full(W),in);

fclose(in.fid);

