function []=tduni_print(res,file_sal)
% PURPOSE: Save output of BFL or Denton temporal disaggregation methods
% ------------------------------------------------------------
% SYNTAX: tduni_print(res,file_sal);
% ------------------------------------------------------------
% OUTPUT: file with detailed output of BFL 
% or Denton (uniequational) temporal disaggregation methods
% ------------------------------------------------------------
% INPUT: res: structure generated by bfl or denton_uni programs
%        file_sal: name of ASCII file for output
% ------------------------------------------------------------
% LIBRARY: 
% ------------------------------------------------------------
% SEE ALSO: bfl, denton_uni, tduni_plot

% written by:
% Enrique M. Quilis
% Instituto Nacional de Estadistica
% Paseo de la Castellana, 183
% 28046 - Madrid (SPAIN)

sep ='----------------------------------------------------';
sep1='****************************************************';

fid=fopen(file_sal,'w');
fprintf(fid,'\n ');
fprintf(fid,'%s \n',sep1);
fprintf(fid,' TEMPORAL DISAGGREGATION METHOD: %s \n ',res.meth);
fprintf(fid,'%s \n',sep1);
fprintf(fid,'%s\n',sep);
fprintf(fid,' Number of low-frequency observations  : %4d\n ',res.N );
fprintf(fid,'Frequency conversion                  : %4d\n ',res.s );
fprintf(fid,'Number of high-frequency observations : %4d\n ',res.N * res.s );
fprintf(fid,'%s\n',sep);
fprintf(fid,' Degree of differencing                : %4d\n ',res.d );
fprintf(fid,' Type of disaggregation: ');
switch res.ta
case 1
   fprintf(fid,'sum (flow). \n');
case 2
   fprintf(fid,'average (index). \n');
case 3
   fprintf(fid,'interpolation (stock last). \n');
case 4
   fprintf(fid,'interpolation (stock first). \n');
end; %of switch ta
fprintf(fid,'%s \n',sep);
fprintf(fid,' High frequency series (columnwise):\n ');
fprintf(fid,'%s \n',sep);
fprintf(fid,'%8.4f\n ',res.y );
fprintf(fid,'%s \n',sep);
fprintf(fid,'\n ');
fprintf(fid,'Elapsed time: %8.4f\n ',res.et);
fclose(fid);
